package easik.sketch.vertex;

/** 
 * The superclass of all nodes on the sketch, has a name and a coordinate.
 * 
 * @author Rob Fletcher 2005 
 */
public abstract class SketchVertex {
	/**
	 * Stores whether this vertex is marked or not
	 */
	protected boolean _marked;
	/**
	 * The x-position of this node
	 */
	protected int _posX;
	/**
	 * The y-position of this node
	 */
	protected int _posY;
	/**
	 * The name of this node
	 */
	protected String _name;
	
	/**
	 * Create a blank sketch vertex, no name, and located at (0, 0)
	 *
	 */
	public SketchVertex() {
		_posX = 0;
		_posY = 0;
		_marked = false;
		_name = "";
	}
	
	/**
	 * Create a vertex with basic attributes
	 * @param name Label
	 * @param x X coordinate
	 * @param y Y coordinate	 
	 */
	public SketchVertex(String name, int x, int y) {
		_posX = x;
		_posY = y;
		_marked = false;
		_name = name;
	}
	
	/**
	 * Mutator for the name field
	 * @param name The new name
	 */
	public void setName(String name) {
		_name = name;
	}
	
	/**
	 * To string method returns the name
	 * @return Current name
	 */
	public String toString() {
			return _name;
	}
	
	/**
	 * Accessor for the name field
	 * @return the name
	 */
	public String getName() {
		return _name;
	}
	
	/**
	 * Accessor for the X coordinate
	 * @return The x coordinate
	 */
	public int getX() {
		return _posX;
	}

	/**
	 * Accessor for the Y Coordinate 
	 * @return	The Y Coordinate
	 */
	public int getY() {
		return _posY;
	}	
	
	/**
	 * Mutator for the X coordinate
	 * @param inX new X coordinate
	 */
	public void setX(int inX) {
		_posX = inX;
	}
	
	/**
	 * Mutator for the Y coordinate 
	 * @param inY The new Y Coordinate
	 */
	public void setY(int inY ){
		_posY = inY;
	}
	
	/**
	 * Mutator for the marked flag. Used when generating SQL 
	 * @param inMark
	 */
	public void setMarked( boolean inMark) {			
			_marked = inMark;
	}
		
	/**
	 * Accessor for the marked flag
	 * @return The marked flag
	 */
	public boolean getMarked() {
		return _marked;
	}
	
}
